<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CBlogWidgetTopicsWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "2",
		"name"	=> "Topics w/ Carousel",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $_SESS;

		$cnt = max(1, $widget["settings"]["set_items"]);

		switch ($widget["settings"]["set_type"]) {
			//latest
			case "1":
				$order = "item_date DESC";
			break;

			//most viewed
			case "2":
				$order = "item_set_views DESC , item_date DESC";
			break;
		}
		

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:blog_topics']} as t , 
				{$this->tables['plugin:blog_topics_lang']} as l ,
				{$this->tables['plugin:blog_authors']} as a , 
				{$this->tables['plugin:blog_authors_lang']} as al 

			WHERE 
				t.item_author=a.author_id AND 
				a.author_id = al.author_id AND 
				al.lang_id = l.lang_id AND 
				t.module_id = {$widget[mod_id]} AND 
				l.lang_id={$widget[lang_id]} AND 
				t.item_id=l.item_id AND
				t.item_status = 1 AND 
				t.item_date <= " . time() . " 
				" . ( $_SESS["client"] ? "" : " AND item_protect=0 ") . " " . 
				($widget["settings"]["set_feat"] ? " AND item_featured " : "" ) . "

			ORDER BY {$order}
			LIMIT $cnt
			"
		);

		if (is_array($items)) {

			global $base;

			$elements = explode("," , $widget["settings"]["set_elements"]);

			$labels = $this->plugins["blog"]->LoadLabels(array("mod_id" => $widget["widget_module"]) , true);

			if ($widget["settings"]["set_carousel"]) {
				$options = array(
					"max"	=> "1",
					"path"	=> "upload/blog",
					"tn"	=> $widget["settings"]["set_media_height"] ? "tn2" : "tn",
				);
			} else {
				$options = array(
					"path"	=> "upload/blog",
					"tn"	=> $widget["settings"]["set_media_height"] ? "tn2" : "tn",

				);
			}
			

			if ($widget["settings"]["set_style"] == "blog-topics-clasic") {
				$widget["settings"]["set_size"] = 
				$widget["settings"]["set_size_lg"] = 
				$widget["settings"]["set_size_md"] = 
				$widget["settings"]["set_size_sm"] = 
				$widget["settings"]["set_size_xs"] = "12";
			}


			foreach ($items as $key => $val) {
				$val["link"] = $items[$key]["link"] = $widget["link"] . $val["item_url"] . "/" . $val["item_id"];
				$this->module->ProcessElements(
					$items[$key], 
					$elements , 
					$this->tpl , 
					"listing" , 
					$widget["mod_settings"] , 
					$widget["settings"]["set_carousel"],
					$this->module->LoadLabels($this->plugins["modules"]->modules[$widget["widget_module"]],  true)
				);
			}
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"items"			=> $base->html->table(
						$this->tpl, 
						"" , 
						$items
					),
					"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),

				),
				array(
					"module_link"	=> $widget["link"]
				),
				$widget,
				$widget["settings"],
				$widget["mod_settings"]
			);
		}

	}
	
}


?>